#!/bin/sh
### 
### This patch is TI-Android-Froyo-Devkit-V2 for bc10
### 
#
#   11/17/2010
#   12/10/2010 : Add camera,overlay
#
############################################################

### Settings
#ANDROID_DIR=${HOME}/TI_Android_FroYo_DevKit-V2/Android_Source_Manifest/rowboat-android
ANDROID_DIR=${HOME}/prebuilt-20110122-DevkitV2/TI-Android-FroYo-DevKit-V2
SETUP_DIR=${HOME}/prebuilt-20110122-DevkitV2/devkitv2-patches-for-bc10
PATCH_DIR=${SETUP_DIR}/patches
###

###
echo " TI-Android-Froyo-Devkit-V2 patches for bc10 "
echo "Start bc10-devkitv2-patch.sh"
echo "Backup original file(s) is B+number Copy new file(s) is C+number..."

echo "Start Section B1 "
echo "Backup hardware files "
VAR=B1
cd ${ANDROID_DIR}
pwd
cd hardware/
pwd

echo "$VAR.50"
if [ -e "libhardware.orig.tar.gz" ];then
    echo "Exist libhardware.orig.tar.gz"
else
    echo "Compress libhardware.orig"
    tar zcf libhardware.orig.tar.gz libhardware
fi

echo "$VAR.51"
if [ -e "libhardware_legacy.orig.tar.gz" ];then
    echo "Exist libhardware_legacy.orig.tar.gz"
else
    echo "Compress libhardware_legacy.orig"
    tar zcf libhardware_legacy.orig.tar.gz libhardware_legacy
fi

cd ti/
echo "$VAR.52"
if [ -e "omap3.orig.tar.gz" ];then
    echo "Exist omap3.orig.tar.gz"
else
    echo "Compress omap3.orig"
    tar zcf omap3.orig.tar.gz omap3
fi


echo "...End backup "
sleep 2

cd ${ANDROID_DIR}
pwd
echo "Section C1 "
echo "Copy new hardware files"
    tar zxf ${PATCH_DIR}/hardware.tar.gz -C ${ANDROID_DIR}/


echo "Section C2 "
echo "Copy new frameworks files"
    tar zxf ${PATCH_DIR}/frameworks.tar.gz -C ${ANDROID_DIR}/

echo "Section C3 "
echo "Copy new device/common files"
    tar zxf ${PATCH_DIR}/device-common.tar.gz -C ${ANDROID_DIR}/


echo "Section C4 "
echo "Copy new device/bc10 files"
    tar zxf ${PATCH_DIR}/bc10.tar.gz -C ${ANDROID_DIR}/device/ti/

echo "End copy files"

