/*
**
** Copyright (C) 2009 0xlab.org - http://0xlab.org/
** Copyright 2008, The Android Open Source Project
**
** Licensed under the Apache License, Version 2.0 (the "License");
** you may not use this file except in compliance with the License.
** You may obtain a copy of the License at
**
**     http://www.apache.org/licenses/LICENSE-2.0
**
** Unless required by applicable law or agreed to in writing, software
** distributed under the License is distributed on an "AS IS" BASIS,
** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
** See the License for the specific language governing permissions and
** limitations under the License.
*/

#ifndef _V4L2CAMERA_H
#define _V4L2CAMERA_H

#define NB_BUFFER 4
#define DEFAULT_FRAME_RATE 30

#include <binder/MemoryBase.h>
#include <binder/MemoryHeapBase.h>
#include <linux/videodev.h>

namespace android {

struct vdIn {
    struct v4l2_capability cap;
    struct v4l2_format format;
    struct v4l2_buffer buf;
    struct v4l2_requestbuffers rb;
    void *mem[NB_BUFFER];
    bool isStreaming;
    int width;
    int height;
    int formatIn;
    int framesizeIn;
};

class V4L2Camera {

public:
    V4L2Camera();
    ~V4L2Camera();

    int Open (const char *device, int width, int height, int pixelformat);
    void Close ();

    int Init ();
    int init_parm();
    void Uninit ();

    int StartStreaming ();
    int StopStreaming ();

    void GrabPreviewFrame (void *previewBuffer);
    char *GrabRawFrame();
    void ProcessRawFrameDone();
    sp<IMemory> GrabJpegFrame ();
    int savePicture(unsigned char *inputBuffer, const char * filename);
    void convert(unsigned char *buf, unsigned char *rgb, int width, int height);

private:
    struct vdIn *videoIn;
    int fd;

    int nQueued;
    int nDequeued;

    int saveYUYVtoJPEG (unsigned char *inputBuffer, int width, int height, FILE *file, int quality);
};

}; // namespace android

#endif
